angular.module('TundraClusterScreen', [])
    .controller('TundraClusterScreenController', function ($scope, $element, $window) {
        const root = document.getElementById('clusterScreen');
        const content = document.getElementById('content');
        const splashScreen = document.getElementById('splashScreen');

        let settings = {}

        // splash: 0 = off, 1 = splash, 2 = on
        let state = { splash: 0, timeout: undefined, lastGear: undefined }

        $window.setup = (data) => {
            settings.speedUnit = data.uiUnitLength === 'metric' ? 'km/h' : 'mph';
            settings.distanceUnit = data.uiUnitLength === 'metric' ? 'km' : 'miles';
            settings.tempUnit = data.uiUnitTemperature.toUpperCase();
            settings.speedConvertion = data.uiUnitLength === 'metric' ? 3.6 : 2.23694;
        }

        $window.updateData = (data) => {
            if (!data) return;

            // Engine/screen state
            if (data.electrics.engineRunning === 0 && state.splash !== 0 && !state.timeout) {
                if (state.timeout) {
                    clearTimeout(state.timeout);
                    state.timeout = undefined;
                }

                // Turn Off
                splashScreen.style.transition = '0.5s ease-out';
                root.classList.add('engineOff');
                state.splash = 0;

                state.timeout = setTimeout(() => {
                    content.style.visibility = 'hidden';
                    state.timeout = undefined;
                }, 0.25 * 1000);
            } else if (data.electrics.engineRunning === 1 && state.splash === 0 && !state.timeout) {
                // Turn on to splash screen
                state.timeout = setTimeout(() => {
                    content.style.visibility = 'hidden';

                    root.classList.remove('engineOff');

                    splashScreen.style.opacity = 1;
                    state.splash = 1;

                    // Hide splash screen
                    state.timeout = setTimeout(() => {
                        splashScreen.style.transition = '0.1s ease-out';
                        content.style.visibility = 'visible';
                        splashScreen.style.opacity = 0;
                        state.splash = 2;
                        state.timeout = undefined;
                    }, 2 * 1000);
                }, 0.5 * 1000);
            }

            // Outside Temp
            document.getElementById('temp').innerText = `${Math.round(data.customModules.environmentData.temperatureEnv)}°${settings.tempUnit}`;

            // Speed
            document.getElementById('speed').innerHTML = `${Math.round(data.electrics.wheelspeed * settings.speedConvertion)} <span class="unit">${settings.speedUnit}</span>`;

            // Range
            document.getElementById('range').innerHTML = `${Math.round(data.customModules.combustionEngineData.remainingRange)} <span class="unit">${settings.distanceUnit}</span>`;

            // Gear
            if (data.electrics.gear === undefined || data.electrics.gear === null) {
                document.getElementById('gears').html = '<span style="color: red">GEARBOX FAILURE</span>';
            } else {
                let gear = data.electrics.gear.toLowerCase();

                if (!['p', 'r', 'n', 'd'].includes(gear)) {
                    if (gear === 0) gear = 'n';
                    if (gear < 0) gear = 'r';
                }

                if (state.lastGear && state.lastGear !== gear) document.getElementById(state.lastGear).classList.remove('active');
                document.getElementById(gear).classList.add('active');
                state.lastGear = gear;
            }

            // Request Service Status
            beamng.sendActiveObjectLua('TundraScreens.requestServiceStatus()');
        }

        // Service status update
        $window.serviceStatusUpdate = (status) => {
            if (status === true) document.getElementById('service').style.visibility = 'shown';
            else document.getElementById('service').style.visibility = 'hidden';
        }

        // Odometer value update (odo value is in km initially)
        $window.odometerUpdate = (odo) => {
            if (settings.distanceUnit === 'km') document.getElementById('odo').innerHTML = `${Math.round(odo)} <span class="unit">${settings.distanceUnit}</span>`;
            else document.getElementById('odo').innerHTML = `${Math.round(odo * settings.speedConvertion)} <span class="unit">${settings.distanceUnit}</span>`;
        }
    });
